﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace ZSMusic.Model
{
    [Serializable]
    public class User
    {
        [Category("主键")]
        [DisplayName("用户ID")]
        [BrowsableAttribute(false)]
        public string Uid { get; set; }

        [Category("基本属性")]
        [DisplayName("用户名")]
        [BrowsableAttribute(false)]
        public string Name { get; set; }

        [Category("基本属性")]
        [DisplayName("密码")]
        [Description("密码")]
        [BrowsableAttribute(false)]
        public string Password { get; set; }

        [Category("我的音乐")]
        [DisplayName("播放列表")]
        [Description("播放列表")]
        public List<Music> PlayList { get; set; }

        [Category("我的音乐")]
        [DisplayName("我的收藏")]
        [Description("我的收藏")]
        public List<Music> Love { get; set; }

        [Category("我的音乐")]
        [DisplayName("播放历史")]
        [Description("播放历史")]
        public List<Music> History { get; set; }

        [Category("我的音乐")]
        [DisplayName("出错音乐")]
        [Description("播放失败的音乐")]
        public List<Music> ErrorMusic { get; set; }

        [Category("基本属性")]
        [DisplayName("歌单")]
        [Description("收藏的歌单")]
        [BrowsableAttribute(false)]
        public List<MusicCollection> MusicCollections { get; set; }

        [Category("自定义属性")]
        [Description("与对象关联的用户定义数据")]
        [BrowsableAttribute(false)]
        public object Tag { get; set; }

        public User()
        {
            Name = Environment.UserName;
            Password = "123456";
            PlayList = new List<Music>();
            Love = new List<Music>();
            History = new List<Music>();
            ErrorMusic = new List<Music>();
            MusicCollections = new List<MusicCollection>();
        }



        //public static User CreateUser()
        //{
        //    User u = new User();
        //    u.Name = Environment.UserName;

        //    return u;
        //}

    }
}